uniform vec4 u_lightCol;
uniform float u_multiplier;
uniform vec2 u_occlusionUVSize;
uniform float u_occlusionVOffset;
varying vec2 v_texCoord;
varying vec4 v_vertexPos;
varying vec2 v_normTexCoord;

#define PI 3.1415926535897932384626433832795
#define PI2 6.28318530717959
#define COEFF_1 0.78539816339745 //PI / 4.0
#define COEFF_2 2.35619449019235 //3.0 * COEFF_1
//#define PARTICLE_LIGHTING_LAYERS 3;

float fastAtan(float y, float x) {
    float abs_y = abs(y);
    float angle;
    
    if (x >= 0.0) {
        float r = (x - abs_y) / (x + abs_y);
        angle = COEFF_1 - COEFF_1 * r;
        
    } else {
        float r = (x + abs_y) / (abs_y - x);
        angle = COEFF_2 - COEFF_1 * r;
    }
    
    return y < 0.0 ? -angle : angle;
}

//sample from the 1D distance map
float sample(vec2 coord, float r) {
    return step(r, texture2D(CC_Texture2, coord).r);
    //return step(r, texture2D(CC_Texture2, coord).r);
    //return texture2D(CC_Texture2, coord).r;
}

void main()
{
    vec4 light = texture2D(CC_Texture1, v_texCoord);
   
    float off= u_occlusionUVSize.x / 128.0 * 0.5;
    
    //rectangular to polar
    //float theta = fastAtan(v_normTexCoord.y, v_normTexCoord.x);
    float theta = fastAtan(v_normTexCoord.y, v_normTexCoord.x);
    float r = length(v_normTexCoord);
    float coord = (theta + PI ) / PI2;
    //coord = mod(coord + off, 1.0);
    //sampling the 1D lookup texture
    //vec2 tc = vec2((1.0 - coord) * u_occlusionUVSize.x, u_occlusionVOffset);
    vec2 tc = vec2(coord * u_occlusionUVSize.x, u_occlusionVOffset);

 
    //the center tex coord, which gives us hard shadows
    float center = sample(tc, r);        

    //we multiply the blur amount by our distance from center
    //this leads to more blurriness as the shadow "fades away"
    //float blur = (1.0/4096.0)  * smoothstep(0.0, 1.0, r); 
	//now we use a simple gaussian blur
	float blur = (u_occlusionUVSize.x/256.0)  * smoothstep(0.0, 1.0, r);
	//float blur = (u_occlusionUVSize.x/64.0) ;
	
    float sum = 0.0;

	//5 Samples gaussian blur
	//Peso prom	0,338709677		0,322580645	0,338709677	
	//Offsets	-1,285714286		0	1,285714286	
	//sum += sample(vec2(mod(tc.x - 1.285714286*blur,u_occlusionUVSize.x), tc.y), r) * 0.338709677;
	//sum += center * 0.322580645;
	//sum += sample(vec2(mod(tc.x + 1.285714286*blur,u_occlusionUVSize.x), tc.y), r) * 0.338709677;

	//9 Samples gaussian blur
	//Peso prom	 -3.2307692308, -1.3846153846,  0.0, 1.3846153846, 3.2307692308 	
	//Offsets	 0.0702702703, 0.3162162162, 0.2270270270, 0.3162162162, 0.0702702703	
	
	//sum += sample(vec2(mod(tc.x - 3.2307692308 * blur,u_occlusionUVSize.x), tc.y), r) * 0.0702702703;
	//sum += sample(vec2(mod(tc.x - 1.3846153846 * blur,u_occlusionUVSize.x), tc.y), r) * 0.3162162162;
	//sum += center * 0.2270270270;
	//sum += sample(vec2(mod(tc.x + 1.3846153846 * blur,u_occlusionUVSize.x), tc.y), r) * 0.3162162162;
	//sum += sample(vec2(mod(tc.x + 3.2307692308 * blur,u_occlusionUVSize.x), tc.y), r) * 0.0702702703;
	
		
	//Old blur
//    sum += sample(vec2(mod(tc.x - 4.0*blur,u_occlusionUVSize.x), tc.y), r) * 0.05;
//    sum += sample(vec2(mod(tc.x - 3.0*blur,u_occlusionUVSize.x), tc.y), r) * 0.09;
//    sum += sample(vec2(mod(tc.x - 2.0*blur,u_occlusionUVSize.x), tc.y), r) * 0.12;
//    sum += sample(vec2(mod(tc.x - 1.0*blur,u_occlusionUVSize.x), tc.y), r) * 0.15;
//    sum += center * 0.16;
//    sum += sample(vec2(mod(tc.x + 1.0*blur,u_occlusionUVSize.x), tc.y), r) * 0.15;
//    sum += sample(vec2(mod(tc.x + 2.0*blur,u_occlusionUVSize.x), tc.y), r) * 0.12;
//    sum += sample(vec2(mod(tc.x + 3.0*blur,u_occlusionUVSize.x), tc.y), r) * 0.09;
//    sum += sample(vec2(mod(tc.x + 4.0*blur,u_occlusionUVSize.x), tc.y), r) * 0.05;
    sum =center;
    //sum of 1.0 -> in light, 0.0 -> in shadow
    
    //sum += sample(vec2(tc.x - 4.0*blur, tc.y), r) * 0.05;
    //sum += sample(vec2(tc.x - 3.0*blur, tc.y), r) * 0.09;
    //sum += sample(vec2(tc.x - 2.0*blur, tc.y), r) * 0.12;
    //sum += sample(vec2(tc.x - 1.0*blur, tc.y), r) * 0.15;
    //sum += center * 0.16;
    //sum += sample(vec2(tc.x + 1.0*blur, tc.y), r) * 0.15;
    //sum += sample(vec2(tc.x + 2.0*blur, tc.y), r) * 0.12;
    //sum += sample(vec2(tc.x + 3.0*blur, tc.y), r) * 0.09;
    //sum += sample(vec2(tc.x + 4.0*blur, tc.y), r) * 0.05;
    
//	gl_FragColor = vec4(light.rgb * u_lightCol.rgb * sum * u_multiplier, light.a* sum) * u_multiplier ;
    
    gl_FragColor = light.rgba * u_lightCol.rgba * sum * u_multiplier;
    
    //gl_FragColor = vec4(light.rgb  * u_lightCol.rgb, light.r) * 10.0;

    
    
    //gl_FragColor = vec4(light.rgb * u_lightCol.rgb * shadow * u_multiplier, 1.0) * 10.0;
}
